/**
  * @file <loop-functions/example/ExampleAggregationLoopFunc.cpp>
  *
  * @author Antoine Ligot - <aligot@ulb.ac.be>
  *
  * @package ARGoS3-AutoMoDe
  *
  * @license MIT License
  */
#include "mission.h"


/****************************************/
/***************************************
TASK 1. FORAGING */

ChocolateMission2LoopFunction::ChocolateMission2LoopFunction() {

  m_fRadius = 0.15;
  m_fNestLimit = -0.8;
  m_cCoordSpot1 = CVector2(0.75,0);
  m_cCoordSpot2 = CVector2(-0.75,0);
  m_fObjectiveFunction = 0;
  //m_bInitializationStep = true;
  //m_punFoodData  = NULL;
  //m_cRegex = std::regex("epuck_?([0-9]+)_?([0-9]+)?");
  m_unNumberEdges=12;
  sidesize=0.66;
  //m_robotmin=m_min_robots;
 // m_decreaseRobots=0;
  //currentnumRobots=m_unNumberRobots;
  //m_robotmin;
  //arena = new Point[m_unNumberEdges];
  //for (UInt32 i = 0; i <= m_unNumberEdges; i++){
  //  arena[i].x=0;
   // arena[i].y=0;
  //}
}


/****************************************/
/****************************************/

ChocolateMission2LoopFunction::ChocolateMission2LoopFunction(const ChocolateMission2LoopFunction& orig) {}

/****************************************/
/****************************************/

ChocolateMission2LoopFunction::~ChocolateMission2LoopFunction() {}

/****************************************/
/****************************************/

void ChocolateMission2LoopFunction::Destroy() {}

/****************************************/
/****************************************/

Real ChocolateMission2LoopFunction::GetObjectiveFunction(){
   return m_fObjectiveFunction;
}

//UInt32 ChocolateMission2LoopFunction::GetNumRobots(){
 // return currentnumRobots;
//}

/****************************************/
/****************************************/

argos::CColor ChocolateMission2LoopFunction::GetFloorColor(const argos::CVector2& c_position_on_plane) {
  CVector2 vCurrentPoint(c_position_on_plane.GetX(), c_position_on_plane.GetY());
  if (IsWithinCircle(vCurrentPoint,m_cCoordSpot1, m_fRadius)){
    return CColor::BLACK;
  }
  if (IsWithinCircle(vCurrentPoint, m_cCoordSpot2, m_fRadius)){
    return CColor::BLACK;
  }
  if (IsWithinRegion(vCurrentPoint, m_fNestLimit)){
    return CColor::WHITE;
  }
  else 
       return CColor::GRAY50;
}


void ChocolateMission2LoopFunction::Init(TConfigurationNode& t_tree) {
  CoreLoopFunctions::Init(t_tree);
  CRadians fAngle=(2*CRadians::PI)/m_unNumberEdges;
 // CQuaternion angleWall;
  fRadius=InnerRadious();

  // Center
 // angleWall.FromEulerAngles(CRadians::PI_OVER_TWO, CRadians::ZERO, CRadians::ZERO);
  //m_pcBoxCenter = new CBoxEntity("wall_center",
  //    CVector3(0, m_cPositionShelter.GetY() - (m_fHeightShelter/2)- (0.05/2), 0.0),
     // angleWall,
    //  false,
     // CVector3(0.05, m_fWidthShelter+0.05, 0.2));
  //AddEntity(*m_pcBoxCenter);
  for(UInt32 i = 0; i < m_unNumberEdges; ++i) {
      //std::ostringstream id;
     // id << this->GetId() << ".wall_" << i;
      std::ostringstream id;
      id  << ".wall_" << i;
      pcWall = new CBoxEntity(id.str().c_str(), CVector3((fRadius * Cos(fAngle * i)),
                                                                              (fRadius * Sin(fAngle * i)),
                                                                              0),
                               CQuaternion().FromEulerAngles(-CRadians::PI +(fAngle * i),CRadians::ZERO,CRadians::ZERO),
                               false,
                               CVector3(0.01,sidesize,0.08),
                               0.2);
      //0.001, 1.0, 0.06
      //arena[i].x=fRadius * Cos(fAngle * i);
     // arena[i].y=fRadius * Sin(fAngle * i);
     // LOG << "x:" << arena[i].x <<" y:"<< arena[i].y << std::endl;
      AddEntity(*pcWall);
    }

    //if (m_unNumberRobots>m_robotmin){
      for (UInt32 i = 1; i <= 19; i++) {
       // RemoveRobot(m_unNumberRobots--);
      } 
    //}
  
}

Real ChocolateMission2LoopFunction::InnerRadious() {
       Real fInnerRadious = (sidesize) / (2 * Tan(CRadians::PI / m_unNumberEdges));
       return fInnerRadious;
}

Real ChocolateMission2LoopFunction::OuterRadius() {
       Real fOutRadious = (sidesize) / (2 * Sin(CRadians::PI / m_unNumberEdges));
       return fOutRadious;
}


void ChocolateMission2LoopFunction::PostStep() {
  UInt32 score_temp = m_fObjectiveFunction;
  CSpace::TMapPerType& tEpuckMap = GetSpace().GetEntitiesByType("epuck");
  CVector2 cEpuckPosition(0,0);
  for (CSpace::TMapPerType::iterator it = tEpuckMap.begin(); it != tEpuckMap.end(); ++it) {
    CEPuckEntity* pcEpuck = any_cast<CEPuckEntity*>(it->second);

    std::string strRobotId = pcEpuck->GetId();
    cEpuckPosition.Set(pcEpuck->GetEmbodiedEntity().GetOriginAnchor().Position.GetX(),
                       pcEpuck->GetEmbodiedEntity().GetOriginAnchor().Position.GetY());


    if (IsWithinCircle(cEpuckPosition, m_cCoordSpot1, m_fRadius)) {
         m_mapFoodData[strRobotId] = 1;
    }

    else if (IsWithinCircle(cEpuckPosition, m_cCoordSpot2, m_fRadius)){
         m_mapFoodData[strRobotId] = 1;

    }
    else if (IsWithinRegion(cEpuckPosition, m_fNestLimit)) {
      std::map<std::string, UInt32>::iterator itFood = m_mapFoodData.find(strRobotId);
      if (itFood != m_mapFoodData.end()) {
        m_fObjectiveFunction += itFood->second;
      }
      m_mapFoodData[strRobotId] = 0;
      // LOG << "Obj " << m_fObjectiveFunction << std::endl;
    }
  }
}



// void ChocolateMission2LoopFunction::PostStep() {
//  //UInt32 score_temp = m_fObjectiveFunction;
//   //bool ch=false;
//   if (m_bInitializationStep) {
//     Initialize();
//   }
//   CSpace::TMapPerType& tEpuckMap = GetSpace().GetEntitiesByType("epuck");
//   CVector2 cEpuckPosition(0,0);
//   UInt32 unId=0;
//   //m_fObjectiveFunction=0;
//  for (CSpace::TMapPerType::iterator it = tEpuckMap.begin(); it != tEpuckMap.end(); ++it) {
//     CEPuckEntity* pcEpuck = any_cast<CEPuckEntity*>(it->second);

//     // expects the id to be in the following form: epuck{robotId} or epuck_{robotId}_{tagId} or epuck_{robotId}
//     std::string strRobotId = pcEpuck->GetId();
//     std::smatch cMatch;
//     bool bMatchFound = std::regex_match(strRobotId, cMatch , m_cRegex);
//     if (bMatchFound) {
//       unId = std::stoi(cMatch[1].str());
//     }

//     //unId = atoi(strRobotId.c_str());
//     cEpuckPosition.Set(pcEpuck->GetEmbodiedEntity().GetOriginAnchor().Position.GetX(),
//                        pcEpuck->GetEmbodiedEntity().GetOriginAnchor().Position.GetY());

//     if (IsWithinCircle(cEpuckPosition, m_cCoordSpot1, m_fRadius) || IsWithinCircle(cEpuckPosition, m_cCoordSpot2, m_fRadius)){
//       m_punFoodData[unId] = 1;
//     }
//     else if(IsWithinRectangle(cEpuckPosition, m_fNestLimit)) {
//       m_fObjectiveFunction= m_fObjectiveFunction + m_punFoodData[unId];
//       m_punFoodData[unId] = 0;
//      // ch=true;

//       // = m_fObjectiveFunction + m_punFoodData[unId];
//       //m_punFoodData[unId] = 0;
//     }

//   }
//   //if (ch)LOG << m_fObjectiveFunction << " " << m_unNumberRobots << std::endl;
// }


// void ChocolateMission2LoopFunction::Initialize() {

//     m_punFoodData = new UInt32[m_unNumberRobots+1];
//     for (UInt32 i = 0; i <= m_unNumberRobots; i++) {
//       m_punFoodData[i] = 0;
//     }
//     m_bInitializationStep = false;
// }


bool ChocolateMission2LoopFunction::IsWithinRegion(CVector2& vCurrentPoint, Real m_fNestLimit){
if (vCurrentPoint.GetY() <= m_fNestLimit)return true;
return false;
}


bool ChocolateMission2LoopFunction::IsWithinCircle(CVector2 c_cEpuckPosition, CVector2& m_cCoordSpot, Real fRadius) {
  //CVector2 vCurrentPoint(c_position_on_plane.GetX(), c_position_on_plane.GetY());
  Real d = (m_cCoordSpot - c_cEpuckPosition).Length();
  if (d <= fRadius) {
    return true;
  }
  return false;
}

void ChocolateMission2LoopFunction::PostExperiment() {
   LOG << "Score_objective:" <<m_fObjectiveFunction << std::endl;
   //m_decreaseRobots++;
   //numRobots++;
}



void ChocolateMission2LoopFunction::Reset() {
  CoreLoopFunctions::Reset();
  std::ios::sync_with_stdio(false);
  m_mapFoodData.clear();
  m_fObjectiveFunction = 0;
  

  //currentnumRobots++;
 // currentnumRobots=(currentnumRobots%m_robotmin)+m_robotmin;
  //CoreLoopFunctions::MoveRobots(currentnumRobots);
  
  //std::ios::sync_with_stdio(false);
 // if (m_punFoodData == NULL) {
  // m_punFoodData = new UInt32[m_unNumberRobots+1];
  //}
  //for (UInt32 i = 0; i <= m_unNumberRobots; i++) {
   // m_punFoodData[i] = 0;
  //}

 //m_fObjectiveFunction = 0;
 //m_bInitializationStep = false;
  
}


void ChocolateMission2LoopFunction::RemoveRobot(int i){
   std::ostringstream id;
   id << "epuck_" << i;
   RemoveEntity(id.str().c_str());
}




CVector3 ChocolateMission2LoopFunction::GetRandomPosition() {
  Real a;
  Real b;
  Real temp;
  Real arbitrary=5.4;
  Real b_max=OuterRadius();
  //b = m_pcRng->Uniform(CRange<Real>(-sidesize,sidesize));
  a = m_pcRng->Uniform(CRange<Real>(-b_max+0.08, m_fNestLimit));
  b = m_pcRng->Uniform(CRange<Real>(-1.0f,1.0f));
 // LOG <<InnerRadious()<< std::endl;
  Real fPosX;
  if (abs(a)<InnerRadious()){//LOG << min(a,InnerRadious())/max(a,InnerRadious()) << std::endl;
  fPosX=ACos(a/InnerRadious()).GetValue();
  }
  else fPosX=ACos(InnerRadious()/a).GetValue();
  //LOG << fPosX << std::endl;
  Real fPosY = b* (b_max-0.08) * sin(fPosX);

  // If b < a, swap them
  //if (b < a) {
 //   temp = a;
 //   a = b;
  //  b = temp;
 // } && pt.x <= m_fNestLimit
 // Point pt = {a, b};
  //LOG << InsidePolygon(arena, m_unNumberEdges, pt) << std::endl;

 //while(!InsidePolygon(arena, m_unNumberEdges, pt)){
 //while (!Is_Inside(pt, arena)){
   // pt.y= m_pcRng->Uniform(CRange<Real>(-sidesize, sidesize));
  //  pt.x= m_pcRng->Uniform(CRange<Real>(-b_max, m_fNestLimit));

   // LOG << pt.x << std::endl;
     

 //}
   
   // LOG << pt.x << std::endl;
   // LOG << pt.y << std::endl;
  //if (checkInside(arena,m_unNumberEdges,pt))
  //Real fPosX = min(a,b) * m_fDistributionRadius * cos(2 * CRadians::PI.GetValue() * (min(a,b)/max(a,b)));
  //Real fPosY = min(a,b) * m_fDistributionRadius * sin(2 * CRadians::PI.GetValue() * (min(a,b)/max(a,b)));
 // return CVector3(pt.x, pt.y, 0);
return CVector3(fPosY, a, 0);
  //return CVector3(2, 2, 0);
  
}



/*
Real ChocolateMission2LoopFunction::InsidePolygon(Point *polygon,int n,Point p)
{
   int i;
   Real angle=0;
   Point p1,p2;

   for (i=0;i<n;i++) {
      p1.x = polygon[i].x - p.x;
      p1.y = polygon[i].y - p.y;
      p2.x = polygon[(i+1)%n].x - p.x;
      p2.y = polygon[(i+1)%n].y - p.y;
      angle += Angle2D(p1.x,p1.y,p2.x,p2.y);
      LOG << "ANGLE:" << angle << std::endl;
   }
    return Abs(angle) - CRadians::PI.GetValue();
   //if (Abs(angle) < CRadians::PI.GetValue())
   //   return false;
  // else
    //  return true;
}*/

/*
   Return the angle between two vectors on a plane
   The angle is from vector 1 to vector 2, positive anticlockwise
   The result is between -pi -> pi
*/
/*Real ChocolateMission2LoopFunction::Angle2D(const Real x1, const Real y1, const Real x2, const Real y2)
{
   Real dtheta,theta1,theta2;
    LOG << "y1:" << y1 << ",x1:" << x1<<std::endl;
   theta1 = ATan2(y1,x1).GetValue();
   theta2 = ATan2(y2,x2).GetValue();
   LOG << "y2:" << y1 << ",x2:" << x1<<std::endl;
    LOG << "THETA1:" << theta1 << std::endl;
    LOG << "THETA2:" << theta2 << std::endl;
   dtheta = theta2 - theta1;
    LOG << "DTHETA:" << dtheta << std::endl;
   while (dtheta > CRadians::PI.GetValue())
      dtheta -=  2* CRadians::PI.GetValue() ;
   while (dtheta < -CRadians::PI.GetValue())
      dtheta += 2* CRadians::PI.GetValue();

   return(dtheta);
}*/






/*bool ChocolateMission2LoopFunction::Is_Inside(Point &point, Point points_list[])
{
    // The winding number counter.
    int winding_number = 0;
    // Loop through all edges of the polygon.
    //typedef std::vector<Point>::size_type size_type;
    //size_type size = points_list.size();
    int size=m_unNumberEdges;
    for (int i = 0; i < size; ++i)             // Edge from point1 to points_list[i+1]
    {
        Point point1={points_list[i].x, points_list[i].y};
        Point point2;
        // Wrap?
        if (i == (size - 1))
        {
            point2.x = points_list[0].x;
            point2.y=points_list[0].y;

        }
        else
        {
            point2.x = points_list[i + 1].x;
            point2.y = points_list[i+1].y;
        }

        if (point1.y <= point.y)                                    // start y <= point.y
        {
            if (point2.y > point.y)                                 // An upward crossing
            {
                if (Is_Left(point1, point2, point) > 0)             // Point left of edge
                {
                    ++winding_number;                               // Have a valid up intersect
                }
            }
        }
        else
        {
            // start y > point.y (no test needed)
            if (point2.y <= point.y)                                // A downward crossing
            {
                if (Is_Left(point1, point2, point) < 0)             // Point right of edge
                {
                    --winding_number;                               // Have a valid down intersect
                }
            }
        }
    }
    return (winding_number != 0);
}

int ChocolateMission2LoopFunction::Is_Left(Point &p0,
            Point &p1,
            Point &point)
{
    return ((p1.x - p0.x) * (point.y - p0.y) -
            (point.x - p0.x) * (p1.y - p0.y));
}*/



// bool ChocolateMission2LoopFunction::InsidePolygon(Point polygon[],int N,Point p)
// {
//   // m_fObjectiveFunction << N << std::endl;
  
//   int counter = 0;
//   int i;
//   Real xinters;
//   Point p1={polygon[0].x, polygon[0].y};
//   Point p2;
//   return true;
//   p1 = polygon[0];
//   for (i=1;i<=N;i++) {
//     p2.x = polygon[i % N].x;
//     p2.y= polygon[i % N].y;
//     if (p.y > min(p1.y,p2.y)) {
//       if (p.y <= max(p1.y,p2.y)) {
//         if (p.x <= max(p1.x,p2.x)) {
//           if (p1.y != p2.y) {
//             xinters = (p.y-p1.y)*(p2.x-p1.x)/(p2.y-p1.y)+p1.x;
//             if (p1.x == p2.x || p.x <= xinters)
//              counter++;
//           }
//         }
//       }
//     }
//     p1.x = p2.x;
//     p1.y=p2.y;
//   }

//   if (counter % 2 == 0) return false;
//   return true;
// }





/*bool ChocolateMission2LoopFunction::OnLine(line l1, Point p) {        //check whether p is on the line or not
   if(p.x <= max(l1.p2.y, l1.p1.y) && p.y <= min(l1.p2.y, l1.p1.y) &&
      (p.y <= max(l1.p2.x, l1.p1.x) && p.x <= min(l1.p1.x, l1.p1.x)))
         return true;

   return false;
}

int ChocolateMission2LoopFunction::Direction(Point a, Point b, Point c) {
   Real val = (b.y-a.y)*(c.x-b.x)-(b.x-a.x)*(c.y-b.y);
   if (val == 0)
      return 0;           //colinear
   else if(val < 0)
      return 2;          //anti-clockwise Direction
      return 1;          //clockwise Direction
}

int ChocolateMission2LoopFunction::min(int a, int b) {return (a>b)?b:a;}
int ChocolateMission2LoopFunction::max(int a, int b) {return (a>b)?a:b;}
Real ChocolateMission2LoopFunction::min(Real a, Real b) {return (a>b)?b:a;}
Real ChocolateMission2LoopFunction::max(Real a, Real b) {return (a>b)?a:b;}

bool ChocolateMission2LoopFunction::IsIntersect(line l1, line l2) {
   //four Direction for two lines and points of other line
   int dir1 = Direction(l1.p2, l1.p1, l2.p2);
   int dir2 = Direction(l1.p2, l1.p1, l2.p1);
   int dir3 = Direction(l2.p2, l2.p1, l1.p2);
   int dir4 = Direction(l2.p2, l2.p1, l1.p1);

   if(dir1 != dir2 && dir3 != dir4)
      return true;           //they are intersecting
   if(dir1==0 && OnLine(l1, l2.p1))        //when p2 of line2 are on the line1
      return true;
   if(dir2==0 && OnLine(l1, l2.p2))         //when p1 of line2 are on the line1
      return true;
   if(dir3==0 && OnLine(l2, l1.p1))       //when p2 of line1 are on the line2
      return true;
   if(dir4==0 && OnLine(l2, l1.p2)) //when p1 of line1 are on the line2
      return true;
   return false;
}

bool ChocolateMission2LoopFunction::CheckInside(Point poly[], int n, Point p) {
   if(n < 3)
      return false;                  //when polygon has less than 3 edge, it is not polygon
   line exline = {p, {9999, p.x}};   //create a point at infinity, y is same as point p
   int count = 0;
   int i = 0;
   do {
      line side = {poly[i], poly[(i+1)%n]};     //forming a line from two consecutive points of poly
      if(IsIntersect(side, exline)) {          //if side is intersects exline
         if(Direction(side.p1, p, side.p2) == 0)
            return OnLine(side, p);
         count++;
      }
      i = (i+1)%n;
   } while(i != 0);
      return count&1;             //when count is odd
}
*/














REGISTER_LOOP_FUNCTIONS(ChocolateMission2LoopFunction, "chocolate_mission2_loop_functions");
